% Baseline RBC Model 
%
% Kuang&Mitra
% After correcting capital taxes
% add consumption tax 17/07/2021

%----------------------------------------------------------------
% 0. Housekeeping (close all graphic windows)
%----------------------------------------------------------------

%close all;



%----------------------------------------------------------------
% 1. Defining variables
%----------------------------------------------------------------

var y c H k inv rk w y_H r U a b g gy by;
varexo gama_x gama_g; 

parameters eps_H sigma psi cy_ratio iy_ratio gy_ratio alpha delta theta gama 
 ik_ratio beta Rbar ay_ratio by_ratio tauk ky_ratio tauH tauC lam1 lam2 sigma_x sigma_g; 


%----------------------------------------------------------------
% 2. Calibration
%----------------------------------------------------------------

beta_tilda = 0.995;

gama = exp(0.036/4);   

Rbar = gama/beta_tilda;

delta = 0.085/4; 

alpha = 0.42; 

eps_H =1/10; 

sigma = 2; 

tauk = 0.3;

tauH = 0.36;

tauC = 0.14; 

gy_ratio = 0.21; 

theta = (Rbar-1)/(1-tauk)/delta+1;

ky_ratio = alpha*gama/((Rbar-1)/(1-tauk)+delta);

ik_ratio = 1-(1-delta)/gama;

iy_ratio = ky_ratio*ik_ratio;

%by_ratio = (-alpha*tauk-(1-alpha)*tauH+gy_ratio+delta/gama*ky_ratio*tauk)/(1-Rbar/gama);
by_ratio =   0.54;

cy_ratio = 1-iy_ratio-gy_ratio;

psi = (1-alpha)/cy_ratio*(1-tauH)/(1+tauC);

ay_ratio = by_ratio+ky_ratio;

lam1 =  0;

lam2 = -0.02;

beta = gama^sigma/Rbar;

sigma_x = 0.003;
sigma_g = 0.003; 



%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model(linear); 
  w-(eps_H-(sigma-1)/sigma*psi)*H-c=0; 
  w = y-H;
  gy = g-y; 
  by = b(-1)-y; 
  rk = gama_x + y -k(-1)-U;
  y = cy_ratio*c + iy_ratio*inv + gy_ratio*g;
  y = alpha*k(-1)+(1-alpha)*H-alpha*gama_x+alpha*U;
  -delta*theta/gama*U-k+ik_ratio*inv-(1-delta)/gama*gama_x+(1-delta)/gama*k(-1)=0;
  -rk/(theta-1) +U = 0 ; 
   y_H = y-H; 
   -sigma*c-psi*(1-sigma)*H= -sigma*c(+1)-psi*(1-sigma)*H(+1)+beta*theta*delta*(1-tauk)/gama^sigma*rk(+1); 
   r = theta*delta*(1-tauk)/Rbar*rk;
   ay_ratio*a-by_ratio*b-ky_ratio*k=0;
   by_ratio*Rbar/gama*(b(-1)+r)-(theta*delta - delta)*tauk/gama*ky_ratio*k(-1) - tauk/gama*ky_ratio*theta*delta*rk
-(1-alpha)*tauH*(w+H)  +gy_ratio*g + ((theta*delta-delta)*tauk/gama*ky_ratio-by_ratio*Rbar/gama)*gama_x - by_ratio*b-cy_ratio*tauC*c=0;


   (gy_ratio+lam1-lam2*by_ratio/gama)*y +lam2*by_ratio/gama*(b(-1)-gama_x)+gama_g-gy_ratio*g = 0; 
 
end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

shocks;
var gama_x = sigma_x^2;
var gama_g = sigma_g^2;
end;



stoch_simul(hp_filter = 1600, order = 1, irf=60);

coeff_k = oo_.dr.ghx;
coeff_u = oo_.dr.ghu;




save('coeff_k','coeff_k');

save('coeff_u','coeff_u');